/*
 * Decompiled with CFR 0.152.
 */
package mjs.processing.mobile.mvideo;

import java.io.InputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.FramePositioningControl;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;
import mjs.processing.mobile.mvideo.MVideoManager;
import processing.core.PImage;
import processing.core.PMIDlet;

public class MVideo
implements PlayerListener {
    public static final int EVENT_STARTED = 1;
    public static final int EVENT_STOPPED = 2;
    public static final int EVENT_END_OF_MEDIA = 3;
    public static final int EVENT_CLOSED = 4;
    public static final int EVENT_ERROR = 5;
    public static final int EVENT_RECORD_STARTED = 6;
    public static final int EVENT_RECORD_STOPPED = 7;
    public static final int EVENT_RECORD_ERROR = 8;
    public static final int EVENT_RECORD_DATA_AVAILABLE = 9;
    public static final int EVENT_VOLUME_CHANGED = 10;
    public static final int EVENT_BUFFERING_STARTED = 11;
    public static final int EVENT_BUFFERING_STOPPED = 12;
    public static final int EVENT_DEVICE_AVAILABLE = 13;
    public static final int EVENT_DEVICE_UNAVAILABLE = 14;
    public static final int EVENT_DURATION_UPDATED = 15;
    public static final int EVENT_STOPPED_AT_TIME = 16;
    public static final int EVENT_SIZE_CHANGED = 17;
    protected Player player;
    protected PMIDlet pMIDlet;
    private VideoControl videoControl;
    private VolumeControl volumeControl;
    private FramePositioningControl framePositioningControl;

    public MVideo(PMIDlet pMIDlet, String locator) {
        this(pMIDlet, locator, null);
    }

    public MVideo(PMIDlet pMIDlet, String locator, String type) {
        this.pMIDlet = pMIDlet;
        try {
            if (locator.startsWith("http://") || locator.startsWith("capture://") || locator.startsWith("file://") || locator.startsWith("rtsp://") || locator.startsWith("rtp://")) {
                this.player = Manager.createPlayer((String)locator);
            } else {
                InputStream inputStream;
                if (type == null) {
                    type = MVideoManager.getMediaType(locator);
                }
                if ((inputStream = this.getClass().getResourceAsStream("/" + locator)) == null) {
                    throw new RuntimeException("File not Found");
                }
                this.player = Manager.createPlayer((InputStream)inputStream, (String)type);
            }
            this.setPlayer(this.player);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void setPlayer(Player player) {
        try {
            this.player = player;
            player.prefetch();
            player.addPlayerListener((PlayerListener)this);
            this.videoControl = (VideoControl)player.getControl("VideoControl");
            if (this.videoControl != null) {
                this.videoControl.initDisplayMode(1, (Object)this.pMIDlet.getCanvas());
                this.videoControl.setVisible(true);
            }
            this.framePositioningControl = (FramePositioningControl)player.getControl("FramePositioningControl");
            player.addPlayerListener((PlayerListener)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected MVideo(PMIDlet pMIDlet, Player videoPlayer) {
        this.pMIDlet = pMIDlet;
        this.setPlayer(this.player);
    }

    public void play() {
        try {
            this.player.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void loop() {
        try {
            this.player.setLoopCount(-1);
            this.play();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void noLoop() {
        try {
            this.player.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void pause() {
        try {
            this.player.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void stop() {
        try {
            this.player.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int duration() {
        return (int)(this.player.getDuration() / 1000000L);
    }

    public int time() {
        return (int)(this.player.getMediaTime() / 1000000L);
    }

    public long mduration() {
        return this.player.getDuration();
    }

    public long mtime() {
        return this.player.getMediaTime();
    }

    public void location(int x, int y) {
        if (this.videoControl != null) {
            this.videoControl.setDisplayLocation(x, y);
        }
    }

    public void size(int width, int height) {
        try {
            if (this.videoControl != null) {
                this.videoControl.setDisplaySize(width, height);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int getX() {
        if (this.videoControl != null) {
            return this.videoControl.getDisplayX();
        }
        return 0;
    }

    public int x() {
        if (this.videoControl != null) {
            return this.videoControl.getDisplayX();
        }
        return 0;
    }

    public int getY() {
        if (this.videoControl != null) {
            return this.videoControl.getDisplayY();
        }
        return 0;
    }

    public int y() {
        if (this.videoControl != null) {
            return this.videoControl.getDisplayY();
        }
        return 0;
    }

    public int getWidth() {
        if (this.videoControl != null) {
            return this.videoControl.getDisplayWidth();
        }
        return 0;
    }

    public int width() {
        if (this.videoControl != null) {
            return this.videoControl.getDisplayWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.videoControl != null) {
            return this.videoControl.getDisplayHeight();
        }
        return 0;
    }

    public int height() {
        if (this.videoControl != null) {
            return this.videoControl.getDisplayHeight();
        }
        return 0;
    }

    public int getSourceWidth() {
        if (this.videoControl != null) {
            return this.videoControl.getSourceWidth();
        }
        return 0;
    }

    public int getSourceHeight() {
        if (this.videoControl != null) {
            return this.videoControl.getSourceHeight();
        }
        return 0;
    }

    public void show() {
        if (this.videoControl != null) {
            this.videoControl.setVisible(true);
        }
    }

    public void show(int x, int y, int width, int height) {
        this.location(x, y);
        this.size(width, height);
        this.show();
    }

    public void hide() {
        if (this.videoControl != null) {
            this.videoControl.setVisible(false);
        }
    }

    public PImage snapshot() {
        try {
            byte[] imageData = this.read();
            if (imageData != null) {
                Image image = Image.createImage((byte[])imageData, (int)0, (int)imageData.length);
                return new PImage(image);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return null;
    }

    public void seekFrame(int frameNumber) {
        if (this.framePositioningControl != null) {
            this.framePositioningControl.seek(frameNumber);
        }
    }

    public void seekTime(long mtime) {
        if (this.framePositioningControl != null) {
            this.framePositioningControl.seek(this.framePositioningControl.mapTimeToFrame(mtime));
        }
    }

    public long frameToTime(int frameNumber) {
        if (this.framePositioningControl != null) {
            return this.framePositioningControl.mapFrameToTime(frameNumber);
        }
        return -1L;
    }

    public int timeToFrame(long mtime) {
        if (this.framePositioningControl != null) {
            return this.framePositioningControl.mapTimeToFrame(mtime);
        }
        return -1;
    }

    public void volume(int amp) {
        if (this.volumeControl == null) {
            this.volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
        }
        if (this.volumeControl != null) {
            this.volumeControl.setLevel(amp);
        }
    }

    public void close() {
        this.hide();
        this.player.close();
    }

    public byte[] read() {
        try {
            if (this.videoControl != null) {
                byte[] imageData = this.videoControl.getSnapshot(null);
                return imageData;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return null;
    }

    public static String[] supportedTypes() {
        return Manager.getSupportedContentTypes(null);
    }

    public static String[] supportedCaptureTypes() {
        return Manager.getSupportedContentTypes((String)"capture");
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (this.pMIDlet == null) {
            return;
        }
        int pEvent = 0;
        if (event.equals("started")) {
            pEvent = 1;
        }
        if (event.equals("stopped")) {
            pEvent = 2;
        } else if (event.equals("endOfMedia")) {
            pEvent = 3;
        } else if (event.equals("closed")) {
            pEvent = 4;
        } else if (event.equals("error")) {
            pEvent = 5;
        } else if (event.equals("recordStarted")) {
            pEvent = 6;
        } else if (event.equals("recordStopped")) {
            pEvent = 7;
        } else if (event.equals("recordError")) {
            pEvent = 8;
        } else if (event.equals("volumeChanged")) {
            pEvent = 10;
        } else if (event.equals("bufferingStarted")) {
            pEvent = 11;
        } else if (event.equals("bufferingStopped")) {
            pEvent = 12;
        } else if (event.equals("deviceAvailable")) {
            pEvent = 13;
        } else if (event.equals("deviceUnavailable")) {
            pEvent = 14;
        } else if (event.equals("durationUpdated")) {
            pEvent = 15;
        } else if (event.equals("stoppedAtTime")) {
            pEvent = 16;
        } else if (event.equals("sizeChanged")) {
            pEvent = 17;
        }
        if (pEvent != 0) {
            this.pMIDlet.enqueueLibraryEvent(this, pEvent, eventData);
        } else {
            this.pMIDlet.enqueueLibraryEvent(this, -1, event);
        }
    }

    public String type() {
        return this.player.getContentType();
    }
}

